unit time;

{$I jgoops.i}

interface

uses Windows, SysUtils, ex2;

function CTime(Time : Long) : String;
function CurrentCTime : ULong;
{$ifdef JGO}
function CTime_DOSTime(Time : Long):integer;
{$endif}

implementation

uses ex2explore;

function CTime(Time : Long) : String;
var
   Date : TDateTime;
   TZInfo : TTimeZoneInformation;
begin
   GetTimeZoneInformation(TZInfo);
   Date := ((Time - (TZInfo.Bias * 60))/ 86400) + 25569;
{$ifdef JGO}
   if mainform.options.us_dates then
   Result := FormatDateTime('mm/dd/yy hh:mm', Date)
   else
{$endif}
   Result := FormatDateTime('dd/mm/yy hh:mm', Date);
end;

function CurrentCTime : ULong;
var
   Date : TDateTime;
   TZInfo : TTimeZoneInformation;
begin
   GetTimeZoneInformation(TZInfo);
   Date := Now;

   Result := Round(((Date - 25569) * 86400) + (TZInfo.Bias * 60));
end;

{$ifdef JGO}
function CTime_DOSTime(Time : Long):integer;
var
   TZInfo : TTimeZoneInformation;
begin
   GetTimeZoneInformation(TZInfo);
   result :=

   DateTimeToFileDate(

   ((Time - (TZInfo.Bias * 60))/ 86400) + 25569

   );

end;
{$endif}

end.
