{****************************************************************************
part_nt.pas
Fri 10/13/2006 1:48 pm  creation

****************************************************************************}

procedure TPartitionList.NT_Scan;
var
   DriveNo    : Integer;
   PartNo     : Integer;
   DeviceName : String;
   h          : THandle;
   Done       : Boolean;
   ErrorNo    : DWORD;
   NewPart    : TPartition;
   i          : Integer;

{$ifdef JGO}
  zcount : integer;
{$endif}

   function CheckForReiser(Part : TPartition) : Boolean;
   var
      Seek       : DWORD;
      Buffer     : String;
      Actual     : DWORD;
   begin
      Result := False;
      SetLength(Buffer, 512);
      Seek := SetFilePointer(h, Part.StartingOffset.QuadPart + 65536, nil, FILE_BEGIN);
      if Seek <> $FFFFFFFF then
      begin
         if ReadFile2(h, PCHAR(Buffer), Length(Buffer), Actual, nil) then
         begin
            // offset 52 should contain 'ReIsEr2Fs'
            if Copy(Buffer, 53, 8) = 'ReIsErFs' then
            begin
               Debug('ReiserFS 3.5 Found. magic = ' + Copy(Buffer, 53, 8), DebugOff);
               Result := True;
            end
            else if Copy(Buffer, 53, 9) = 'ReIsEr2Fs' then
            begin
               Debug('ReiserFS 3.6 Found. magic = ' + Copy(Buffer, 53, 9), DebugOff);
               Result := True;
            end
            else if Copy(Buffer, 53, 9) = 'ReIsEr3Fs' then
            begin
               Debug('ReiserFS JR Found. magic = ' + Copy(Buffer, 53, 9), DebugOff);
               Result := True;
            end
            else if Copy(Buffer, 0, 7) = 'ReIsEr4' then
            begin
               Debug('ReiserFS 4.0 (libreiser) Found. magic = ' + Copy(Buffer, 0, 7), DebugOff);
               Result := True;
            end;
         end;
      end;
   end;

   function CheckForLVM : Boolean;
   var
      Seek       : DWORD;
      Buffer     : String;
      Magic      : String;
      UID        : String;
      Actual     : DWORD;
   begin
      Result := False;
      SetLength(Buffer, 512);
      Seek := SetFilePointer(h, 512, nil, FILE_BEGIN);
      if Seek <> $FFFFFFFF then
      begin
         if ReadFile2(h, PCHAR(Buffer), Length(Buffer), Actual, nil) then
         begin
            // offset 25 should contain 'LVM2'
            Magic := Copy(Buffer, 25, 8);
            Debug('Magic = ' + Magic, DebugHigh);
            if Magic = 'LVM2 001' then
            begin
               Debug('LVM2 Found. magic = ' + Magic, DebugOff);

               UID := Copy(Buffer, 33, 32);
               Debug('PV UID = ' + UID, DebugOff);
               Result := True;
            end;
         end;
      end;
   end;

{$ifdef JGO}
{****************************************************************************
+ Fri 10/13/2006 10:31 am. So on carol (machine in my menagerie), his
partitions show the wrong numbers. But if I count the "magics" in the debug
file, they would be right. He's counting wrong somehow. I think "inc(PartNo)"
is the guy in partitions.pas. // the magics were nothing. The problem is, he
uses the winders count, which skips things like extended partitions.

Well it's somewhere in the mystery and madness of TPartitionList.NT_Scan. //
Well it looks perfectly kosher....

****************************************************************************}


  function CheckForJGO(Part : TPartition) : Boolean;
  var
    Seek     : DWORD;
    Buffer    : String;
//    Magic    : String;
//    UID      : String;
    Actual    : DWORD;    //result from readfile
    i : integer;

  begin
    Debug(
    format('CheckForJgo Partition #%d',[partno])
    ,DebugHIGH);


    Result := False;
    SetLength(Buffer, 512);
    Seek := SetFilePointer(h, 512, nil, FILE_BEGIN);

    if Seek <> $FFFFFFFF then
    begin
      if ReadFile2(h, PCHAR(Buffer), Length(Buffer), Actual, nil) then
      begin
        for i := 1 to length(buffer) do begin
          if ord(buffer[i])<>0 then
          exit;   //with false, u know....
        end;

        Debug(
        format('CheckForJgo Partition #%d is zero',[partno])
        ,DebugHIGH);
        result := true;   //it was all zero.
      end;
    end;
  end;



{****************************************************************************
Wed 4/26/2006 7:58 pm. so at least this one didn't see windows partitions as
linux. And the estimable Newbigin try/excepts everything -- so it just GPFs
anyway when you try to look at one....

So I also arranged the checkfors so it does the other partitions first --
which might be useful if one used some other trickery to identify a
superblock.

See, the problem is your superior so-safe XP *doesn't let you look at the
partition block itself* see? So you can't *tell* what type it is....
****************************************************************************}

   function CheckForExt(Part : TPartition) : Boolean;
   var
      Seek       : DWORD;
      Superblock : ext2_super_block;
      Actual     : DWORD;
   begin
      Result := False;

      Seek := SetFilePointer(h, Part.StartingOffset.QuadPart + 1024, nil, FILE_BEGIN);
      if Seek <> $FFFFFFFF then
      begin
         if ReadFile2(h, @superblock, sizeof(superblock), Actual, nil) then
         begin
            if
            (superblock.s_magic = EXT2_SUPER_MAGIC)
            or
            (mainform.options.assumeExt2 and
            (superblock.s_magic = EXT2_PARTITION_MAGIC)
            )
//            or true //test crashing on xp for wrong partitions.
            then
            begin
               Debug(DeviceName, DebugLow);
               Debug('EXT2 Found. magic = 0x' + IntToHex(superblock.s_magic, 4), DebugOff);
               Debug('UID = ' + UuidToStr(superblock.s_uuid), DebugOff);
               Result := True;
            end;
         end;
      end;
   end;
{$else}
   function CheckForExt(Part : TPartition) : Boolean;
   var
      Seek       : DWORD;
      Superblock : ext2_super_block;
      Actual     : DWORD;
   begin
      Result := False;

      Seek := SetFilePointer(h, Part.StartingOffset.QuadPart + 1024, nil, FILE_BEGIN);
      if Seek <> $FFFFFFFF then
      begin
         if ReadFile2(h, @superblock, sizeof(superblock), Actual, nil) then
         begin
            if
            (superblock.s_magic = EXT2_SUPER_MAGIC)
            then
            begin
               Debug(DeviceName, DebugLow);
               Debug('EXT2 Found. magic = 0x' + IntToHex(superblock.s_magic, 4), DebugOff);
               Debug('UID = ' + UuidToStr(superblock.s_uuid), DebugOff);
               Result := True;
            end;
         end;
      end;
   end;
{$endif}

   procedure HexDump(Offset : Int64; Length : Integer);
   var
      ReadStart  : _Large_Integer;
      Seek       : DWORD;
      Buffer     : String;
      S  : String;
      S2 : String;
      i  : Integer;
      Actual     : DWORD;
   begin
      ReadStart.QuadPart := Offset;
      Seek := SetFilePointer(h, Offset, nil, FILE_BEGIN);
      if Seek <> $FFFFFFFF then
      begin
         SetLength(Buffer, Length);
         if ReadFile2(h, PCHAR(Buffer), Length, Actual, nil) then
         begin
            Debug('Disk dump offset = ' + IntToStr(Offset) + ' size = ' + IntToStr(Length), DebugOff);
            Debug('actual read = ' + IntToStr(Actual), DebugOff);
            S := '0000 ';
            for i := 0 to Length - 1 do
            begin
               S := S + IntToHex(Ord(PChar(Buffer)[i]), 2);
               if not (ord(PChar(Buffer)[i]) in [0, 8, 9]) then
               begin
                  S2 := S2 + PChar(Buffer)[i];
               end
               else
               begin
                  S2 := S2 + ' ';
               end;
               S := S + ' ';
               if System.Length(S) >= 52 then
               begin
                  Debug(S + ' ' + S2, DebugOff);
                  S := IntToHex(i + 1, 4) + ' ';
                  s2 := '';
               end;
            end;
         end
         else
         begin
            Debug('Error reading file ' + IntToStr(GetLastError) + ' ' + SysErrorMessage(GetLastError), DebugHigh);
         end
      end
      else
      begin
         Debug('Seek failed error=' + IntToStr(GetLastError), DebugHigh);
      end;
   end;
begin
   DriveNo := 0;

   Done := False;

{$ifdef JGO}
  zcount := 0;
{$endif}

   while not Done do
   begin
      PartNo := 0;
      while True do
      begin
         DeviceName := '\Device\Harddisk' + IntToStr(DriveNo) + '\Partition' + IntToStr(PartNo);
         //Debug(DeviceName, DebugOff);

         // try and open the file.
         h := NTCreateFile(PChar(DeviceName), GENERIC_READ, FILE_SHARE_READ, nil, OPEN_EXISTING, FILE_FLAG_RANDOM_ACCESS, 0);

         if h <> INVALID_HANDLE_VALUE then    //opened hard drive.
         begin
            try
            // check for Ext2
               //Debug('Opened ' + DeviceName, DebugLow);

{               if NTReadFile2(h, @superblock, sizeof(superblock), Actual, nil) then
               begin
                  if Actual = sizeof(superblock) then
                  begin
//                     Debug('read superblock', DebugOff);
                     // check the magic number
                     if superblock.s_magic = EXT2_SUPER_MAGIC then
                     begin
                        Debug(DeviceName, DebugLow);
                        Debug('EXT2 Found. magic = 0x' + IntToHex(superblock.s_magic, 4), DebugOff);

                        // Add a record...
                        NewPart := TPartition.Create;
                        Partitions.add(NewPart);

                        NewPart.DriveNo := DriveNo;
                        NewPart.PartNo := PartNo;
                        NewPart.FileName := DeviceName;
                        NewPart.BytesPerSector     := 512;
                        NewPart.MediaType          := Media_Type_FixedMedia;
                        NewPart.PartitionType            := PARTITION_LINUX;
                        NewPart.RecognizedPartition      := True;
                        NewPart.RewritePartition         := False;
                        NewPart.StartingOffset.QuadPart  := 0;
                        NewPart.PartitionLength.QuadPart := $FFFFFFFFFFFFFFFF;
                        NewPart.HiddenSectors            := 0;

                     end;
                  end
                  else
                  begin
                     Debug('Only read ' + IntToStr(Actual) + ' bytes', DebugHigh);
                  end;
               end
               else
               begin
                  Debug('Error reading file ' + IntToStr(GetLastError) + ' ' + SysErrorMessage(GetLastError), DebugHigh);
               end;
}
               NewPart := TPartition.Create;

               NewPart.DriveNo                  := DriveNo;
               NewPart.PartNo                   := PartNo;
               NewPart.FileName                 := DeviceName;
               NewPart.BytesPerSector           := 512;
               NewPart.MediaType                := Media_Type_FixedMedia;
               NewPart.PartitionType            := 0;
               NewPart.RecognizedPartition      := True;
               NewPart.RewritePartition         := False;
               NewPart.StartingOffset.QuadPart  := 0;
               NewPart.PartitionLength.QuadPart := $FFFFFFFFFFFFFFFF;
               NewPart.HiddenSectors            := 0;
{$ifdef JGO}
               NewPart.zcount := zcount;
{$endif}


{$ifndef JGO}
               if CheckForExt(NewPart) then
               begin
                  NewPart.PartitionType := PARTITION_LINUX;
                  Partitions.add(NewPart);
                  NewPart := nil;
               end
               else
{$endif}
               if CheckForReiser(NewPart) then
               begin
                  ReiserFSCount := ReiserFSCount + 1;
               end
               else if CheckForLVM then
               begin
                  Debug('Adding ' + DeviceName + ' to PV list', DebugOff);
                  LVM2AddPV(DeviceName);
               end
{$ifdef JGO}
               else if CheckForExt(NewPart) then
               begin
                  NewPart.PartitionType := PARTITION_LINUX;
                  Partitions.add(NewPart);
                  NewPart := nil;
               end
               else if CheckForJGO(NewPart) then
               inc(zcount)
{****************************************************************************
Fri 10/13/2006 4:37 pm. I'm guessing CheckForJGO finds a logical partition or
something or other. See the esteemed original author uses the NT partition
numbers which are the numbers of things you *ought* to see. But I'm probably
guessing wrong. However, worked once, and since it's just used to change the
partition number in the GUI display (see LinuxFS .description), and they were
wrong to start with, what the hey....
****************************************************************************}

{$endif}
               ;

               if Assigned(NewPart) then
               begin
                  // not used...
                  NewPart.Free;
               end;
            finally
               CloseHandle(h);
            end;
         end    //if h<> INVALID_HANDLE_VALUE
         else
         begin  //h = invalid_handle_value I guess.
            ErrorNo := Native.GetLastError;
            if ErrorNo = ERROR_FILE_NOT_FOUND then
            begin
               if PartNo = 0 then
               begin
                  Done := True;
               end;
               break;
            end
            else if ErrorNo = ERROR_PATH_NOT_FOUND then
            begin
               Done := True;
               break;
            end
            else if ErrorNo = 5 then
            begin
               MessageDlg('This program requires Administrator privilages to read harddisks', mtError, [mbOK], 0);
               break;
            end
            else if ErrorNo = 32 then
            begin
               // in use by something else (probably mounted)
               // ignore
            end
            else
            begin
               Debug('GetLastError = (' + IntToStr(ErrorNo) + ') ' + SysErrorMessage(ErrorNo), DebugLow);
            end;
         end;   //h = invalid_handle_value.
         PartNo := PartNo + 1;
      end;
      DriveNo := DriveNo + 1;
   end;

   //LVM2AddPV('\??\f:\image3');

   LVMBuildLV(Partitions);
   // now check any partitions which might have been added by LVM
   for i := 0 to Partitions.Count - 1 do
   begin
      NewPart := TPartition(Partitions[i]);
      if NewPart.PartitionType = 0 then
      begin
         h := NTCreateFile(PChar(NewPart.FileName), GENERIC_READ, FILE_SHARE_READ, nil, OPEN_EXISTING, FILE_FLAG_RANDOM_ACCESS, 0);

         if h <> INVALID_HANDLE_VALUE then
         begin
            if CheckForExt(NewPart) then
            begin
               NewPart.PartitionType := PARTITION_LINUX;
            end
            else
            begin
               if CheckForReiser(NewPart) then
               begin
                  ReiserFSCount := ReiserFSCount + 1;
               end;
               // delete it cos it aint ext
               Partitions[i] := nil;
               NewPart.Free;
            end;
            CloseHandle(h);
         end;
      end;
   end;
end;


