{****************************************************************************
part_low.pas
Fri 10/13/2006 1:46 pm  creation.

Fri 10/13/2006 1:45 pm. I made this into include file to partitions.pas
wouldn't be so humongous.
****************************************************************************}

// This does a Low Level scan (reads partition table from disk);
procedure TPartitionList.LL_Scan(PartType : Integer);
var
   DriveNo  : Integer;
   FileName : String;
   h        : THandle;
   Err      : Integer;
   Geometry : TDISK_GEOMETRY;
   Length   : DWORD;
   PartNo   : Integer;
   ExtendedStart : ULong;

   procedure AddFloppy(h : THandle);
   var
      Size     : DWORD;
      NewPart  : TPartition;
   begin
      NewPart := TPartition.Create;
      Partitions.add(NewPart);
      NewPart.DriveNo   := DriveNo;
      NewPart.FileName  := FileName;

      NewPart.Cylinders          := Geometry.Cylinders;
      NewPart.TracksPerCylinder  := Geometry.TracksPerCylinder;
      NewPart.SectorsPerTrack    := Geometry.SectorsPerTrack;
      NewPart.BytesPerSector     := Geometry.BytesPerSector;
      NewPart.MediaType          := Geometry.MediaType;

      Size := {Round}(Geometry.Cylinders.QuadPart) * Geometry.TracksPerCylinder * Geometry.SectorsPerTrack;

      NewPart.PartitionType            := PartType;
      NewPart.BootIndicator            := False;
      NewPart.RecognizedPartition      := True;
      NewPart.RewritePartition         := False;
      NewPart.PartNo                   := 0;
      NewPart.StartingOffset.QuadPart  := 0;
      NewPart.PartitionLength.QuadPart := Size;
      NewPart.PartitionLength.QuadPart := NewPart.PartitionLength.QuadPart * Geometry.BytesPerSector;
      NewPart.HiddenSectors            := 0;
   end;

   function ProcessSector(h : THandle; Sector : ULong; Depth : Integer) : Boolean;
   var
      Size     : DWORD;
      Buffer   : TDiskTable;
      i        : Integer;
      SeekPos  : _LARGE_INTEGER; //TLargeInteger;
      NewPart  : TPartition;
   begin
      Result := True;
      Size := sizeof(Buffer);
      Debug(
{$ifdef JGO}
      sep+
{$endif}
      'Looking for table at sector ' + IntToStr(Sector), DebugMedium);


      SeekPos.QuadPart := Sector;
      SeekPos.QuadPart := SeekPos.QuadPart * 512;

      if SetFilePointer(h, SeekPos.LowPart, @SeekPos.HighPart, FILE_BEGIN) = $FFFFFFFF then
      begin
         Debug('Seek error ' + IntToStr(GetLastError), DebugOff);
         Result := False;
      end
      else
      begin
         if not ReadFile2(h, @Buffer, Size, Size, nil) then
         begin
            Result := False;
            exit;
         end;
         Debug('Signature is ' + IntToHex(Buffer.Signature, 4), DebugMedium);
         if (Buffer.Signature = $AA55) then
         begin
            for i := 1 to 4 do
            begin
               Debug(
{$ifdef JGO}
               sep+
{$endif}
               'Processing partitions', DebugMedium);
               if Buffer.Table[i].sys_ind <> 0 then
               begin
                  Debug(
{$ifdef JGO}
                  sep+
{$endif}
                  'Partition           ' + IntToStr(i) + ' /dev/hdx' + IntToStr(PartNo), DebugMedium);
                  Debug(' boot indicator      ' + IntToHex(Buffer.Table[i].boot_ind,2), DebugHigh);
                  Debug(' starting cylinder   ' + IntToStr(Buffer.Table[i].cyl), DebugHigh);
                  Debug(' starting head       ' + IntToStr(Buffer.Table[i].head), DebugHigh);
                  Debug(' starting sector     ' + IntToStr(Buffer.Table[i].sector), DebugHigh);
                  Debug(' partition type      ' + IntToHex(Buffer.Table[i].sys_ind,2), DebugMedium);
                  case Buffer.Table[i].sys_ind of
                     PARTITION_EXTENDED         : Debug('                     Extended... (dos)', DebugMedium);
                     PARTITION_EXTENDED_LINUX   : Debug('                     Extended... (linux)', DebugMedium);
                     PARTITION_EXTENDED_WIN98   : Debug('                     Extended... (win98)', DebugMedium);
                     PARTITION_FAT_16           : Debug('                     FAT 16', DebugMedium);
                     PARTITION_HUGE             : Debug('                     VFAT', DebugMedium);
                     PARTITION_IFS              : Debug('                     NTFS', DebugMedium);
                     PARTITION_LINUX            : Debug('                     Linux', DebugMedium);
                     PARTITION_LINUX_SWAP       : Debug('                     Linux Swap', DebugMedium);
                  else
                     Debug('Unknown', DebugMedium);
                  end;
                  Debug(' end cylinder        ' + IntToStr(Buffer.Table[i].end_cyl), DebugHigh);
                  Debug(' end head            ' + IntToStr(Buffer.Table[i].end_head), DebugHigh);
                  Debug(' end sector          ' + IntToStr(Buffer.Table[i].end_sector), DebugHigh);
                  Debug(' starting sector     ' + IntToStr(Buffer.Table[i].start_sect), DebugMedium);
                  Debug(' number of sectors   ' + IntToStr(Buffer.Table[i].nr_sects), DebugMedium);
                  Debug('', DebugMedium);


//                  else
                  begin
                     if (Buffer.Table[i].sys_ind = PartType) or (PartType = 0) then
                     begin
                        NewPart := TPartition.Create;
                        Partitions.add(NewPart);
                        NewPart.DriveNo   := DriveNo;
                        NewPart.FileName  := FileName;

                        NewPart.Cylinders          := Geometry.Cylinders;
                        NewPart.TracksPerCylinder  := Geometry.TracksPerCylinder;
                        NewPart.SectorsPerTrack    := Geometry.SectorsPerTrack;
                        NewPart.BytesPerSector     := Geometry.BytesPerSector;
                        NewPart.MediaType          := Geometry.MediaType;

                        NewPart.PartitionType            := Buffer.Table[i].sys_ind;
                        NewPart.BootIndicator            := (Buffer.Table[i].boot_ind = $80);
                        NewPart.RecognizedPartition      := True;
                        NewPart.RewritePartition         := False;
                        NewPart.PartNo                   := PartNo;
                        NewPart.StartingOffset.QuadPart  := (Buffer.Table[i].start_sect + Sector);// Offset from start of partition
                        NewPart.StartingOffset.QuadPart  := NewPart.StartingOffset.QuadPart * Geometry.BytesPerSector;
                        NewPart.PartitionLength.QuadPart := Buffer.Table[i].nr_sects;
                        NewPart.PartitionLength.QuadPart := NewPart.PartitionLength.QuadPart * Geometry.BytesPerSector;
                        NewPart.HiddenSectors            := 0;

                     end;
//                     if (Buffer.Table[i].sys_ind = PARTITION_EXTENDED) and (PartNo > 4) then
                     if (Buffer.Table[i].sys_ind in EXTENDED_PARTITIONS) and (PartNo > 4) then
                     begin
                        Dec(PartNo); // We do not want to assign a number to extend partitions after the 1st (I don't know why?, it is what Linux does)
                     end;
                  end;
                  Inc(PartNo);
               end;
            end;
            for i := 1 to 4 do
            begin
               if Buffer.Table[i].sys_ind in EXTENDED_PARTITIONS then
               begin
                  Debug('Processing extended partition....', DebugMedium);
                  if Depth < 32 then
                  begin
                     if PartNo < 5 then
                     begin
                        PartNo := 5;
                     end;
                     if Depth = 1 then
                     begin
                        ExtendedStart := Sector;
                     end;
                     // There is a new partition table at offset start_sect...
                     if Depth >= 2 then
                     begin
                     if not ProcessSector(h, ExtendedStart + Buffer.Table[i].start_sect, Depth + 1) then
                        begin
                           Debug('Did not seem to be a valid extended partition', DebugMedium);
                        end;
                     end
                     else
                     begin
                        if not ProcessSector(h, Sector + Buffer.Table[i].start_sect, Depth + 1) then
                        begin
                           Debug('Did not seem to be a valid extended partition', DebugMedium);
                        end;
                     end;
                  end
                  else
                  begin
                     Debug('More than 32 partitions detected! This is most likely a bug!', DebugOff);
                  end;
               end;
            end;
         end
         else
         begin
            Result := False;
         end;
      end;
   end;
begin
   DriveNo := 0;

   while true do
   begin
      Debug('Opening device...', DebugHigh);
      FileName := '\\.\PHYSICALDRIVE' + IntToStr(DriveNo);
      Debug(FileName, DebugMedium);
      h := Windows.CreateFile(PChar(FileName), GENERIC_READ, FILE_SHARE_READ    , nil, OPEN_EXISTING, 0, 0);
      if h = INVALID_HANDLE_VALUE then
      begin
         Err := GetLastError;
         if Err = 5 then
         begin
            MessageDlg('This program requires Administrator privilages to run', mtError, [mbOK], 0);
            break; // out of while loop
         end
         else if Err = 2 then
         begin
            // no more physical drives found...
            break;
         end
         else if Err = 0 then
         begin
            // this is not an error
            break;
         end
         else
         begin
            Debug('Unknown error scanning ' + FileName + ' errorcode = ' + IntToStr(Err), DebugOff);
            Debug(SysErrorMessage(Err), DebugOff);
            break;
         end;
      end
      else // we have the handle, lets look at the partitions....
      begin
         // first see if the media is present...
         if not MediaPresent(h) then
         begin
            Debug('Media not present', DebugOff);
         end
         else
         begin
            Debug('Reading drive geometry...', DebugHigh);
            if not DeviceIOControl(h, CtlCode(FILE_DEVICE_DISK, 0, METHOD_BUFFERED, FILE_ANY_ACCESS),
                              nil, 0,
                              Pointer(@Geometry), sizeof(Geometry),
                              Length, nil) then
            begin
               MessageDlg('Error reading drive geometry. errorcode = ' + IntToStr(GetLastError), mtError, [mbOK], 0);
               break;
            end;
            Debug('Disk Geometry...', DebugHigh);
            Debug(' Cylinders ' + IntToStr(Geometry.Cylinders.QuadPart), DebugHigh);
            Debug(' ' + MediaDescription(Geometry.MediaType), DebugMedium);
            Debug(' Tracks/Cylinder ' + IntToStr(Geometry.TracksPerCylinder), DebugHigh);
            Debug(' Sectors/Track   ' + IntToStr(Geometry.SectorsPerTrack), DebugHigh);
            Debug(' Bytes/Sector    ' + IntToStr(Geometry.BytesPerSector), DebugHigh);
            // Time to read the table
            PartNo := 1;
            ExtendedStart := 0;
            ProcessSector(h, 0, 0);
         end;
         CloseHandle(h);
         Inc(DriveNo);
      end;
   end;

   ////////////////////////////////////////////
   ////////////////////////////////////////////
   ////////////////////////////////////////////
   ////////////////////////////////////////////

   if ScanFloppy then
   begin
      DriveNo := 0;

      while true do
      begin
         FileName := '\\.\' + Char(Ord('A') + DriveNo) + ':';
         Debug(FileName, DebugMedium);
         h := CreateFile(PChar(FileName), GENERIC_READ, FILE_SHARE_READ, nil, OPEN_EXISTING, 0, 0);
//         h := CreateFile(PChar(FileName), 0, FILE_SHARE_READ, nil, OPEN_EXISTING, 0, 0);
         if h = INVALID_HANDLE_VALUE then
         begin
            Err := GetLastError;
            if Err = 5 then
            begin
               MessageDlg('This program requires Administrator privilages to run', mtError, [mbOK], 0);
               break; // out of while loop
            end
            else if Err = 2 then
            begin
               // no more physical drives found...
               break;
            end
            else if Err = 21 then
            begin
               Debug('Drive not ready (no disk?)', DebugMedium);
               break;
            end
            else if Err = 0 then
            begin
               // this is not an error
               break;
            end
            else
            begin
               Debug('Unknown error scanning ' + FileName + ' errorcode = ' + IntToStr(Err), DebugOff);
               Debug(SysErrorMessage(Err), DebugOff);
               break;
            end;
         end
         else // we have the handle, lets look at the partitions....
         try
//            LockVolume(h);
            // first see if the media is present...
            begin
               if not DeviceIOControl(h, CtlCode(FILE_DEVICE_DISK, 0, METHOD_BUFFERED, FILE_ANY_ACCESS),
                                 nil, 0,
                                 Pointer(@Geometry), sizeof(Geometry),
                                 Length, nil) then
               begin
                  Err := GetLastError;
                  if Err <> 21 then
                  begin
                     MessageDlg('Error reading drive geometry. errorcode = ' + IntToStr(GetLastError), mtError, [mbOK], 0);
                  end;
                  break;
               end;
               Debug(MediaDescription(Geometry.MediaType), DebugMedium);
               if (Geometry.MediaType = Media_Type_Unknown) and (MediaPresent(h) = False) then
               begin
                  Debug('Media not present', DebugOff);
               end
               else
               begin
                  // Time to read the table
                  PartNo := 1;
                  ExtendedStart := 0;
                  ProcessSector(h, 0, 0);
                  Debug('PartNo = ' + IntToStr(PartNo), DebugMedium);
//                  if PartNo = 1 then
                  begin
                     // no Partitons found, should we add the whole disk?
                     AddFloppy(h);
                  end;
               end;
            end;
         finally
//            UnLockVolume(h);
            CloseHandle(h);
            Inc(DriveNo);
         end;
      end;
   end;
end;


