{****************************************************************************
part_95.pas
Fri 10/13/2006 1:49 pm  creation.

Imposing order of partition.pas....

****************************************************************************}

////////////////////////////////////
////////////////////////////////////
// Windows 95 scan
// This does a Low Level scan (reads partition table from disk);
// This is the same as LL_Scan, but it uses the DiskIO unit

procedure TPartitionList.Win95_Scan(PartType : Integer; UseEI13 : Boolean);
var
   DriveNo  : Integer;
   PartNo   : Integer;
   ExtendedStart : ULong;
   Disk     : T95Disk;

   procedure AddFloppy(Disk : T95Disk);
   var
      Size     : DWORD;
      NewPart  : TPartition;
   begin
      NewPart := TPartition.Create;
      Partitions.add(NewPart);
      NewPart.DriveNo   := DriveNo;
      NewPart.FileName  := '';

      NewPart.Cylinders.QuadPart := Disk.GetGeometry.Cylinder + 1;
      NewPart.TracksPerCylinder  := Disk.GetGeometry.Head + 1;
      NewPart.SectorsPerTrack    := Disk.GetGeometry.Sector;
      NewPart.BytesPerSector     := 512;
      NewPart.MediaType          := Media_Type_RemovableMedia;

      Size := Disk.SectorCount * 512;

      NewPart.PartitionType            := PartType;
      NewPart.BootIndicator            := False;
      NewPart.RecognizedPartition      := True;
      NewPart.RewritePartition         := False;
      NewPart.PartNo                   := 0;
      NewPart.StartingOffset.QuadPart  := 0;
      NewPart.PartitionLength.QuadPart := Size;
      NewPart.PartitionLength.QuadPart := NewPart.PartitionLength.QuadPart * 512;
      NewPart.HiddenSectors            := 0;
   end;

   function CheckForReiser(Disk : T95Disk; Sector : ULong) : Boolean;
   var
      Buffer     : String;
      Magic      : String;
   begin
      Result := False;
      SetLength(Buffer, 512);
      if Disk.ReadSector(Sector + 128, PChar(Buffer), 1) then
      begin
         // offset 52 should contain 'ReIsEr2Fs'
         Magic := Copy(Buffer, 53, 9);
         Debug('Magic = ' + Magic, DebugHigh);
         if Magic = 'ReIsEr2Fs' then
         begin
            Debug('ReiserFS Found. magic = ' + Magic, DebugOff);
            Result := True;
         end;
      end;
   end;


   function ProcessSector(Disk : T95Disk; Sector : ULong; Depth : Integer) : Boolean;
   var
      Size     : DWORD;
      Buffer   : TDiskTable;
      i        : Integer;
      NewPart  : TPartition;
      Superblock : ext2_super_block;

   begin
      Result := True;
      Size := sizeof(Buffer);
      Debug(
{$ifdef JGO}
      sep+
{$endif}
      'Looking for table at sector ' + IntToStr(Sector), DebugMedium);

      if not Disk.ReadSector(Sector, @Buffer, size div 512) then
         begin
            Result := False;
            exit;
         end;
         Debug('Signature is ' + IntToHex(Buffer.Signature, 4), DebugMedium);
         if (Buffer.Signature = $AA55) then
         begin
            for i := 1 to 4 do
            begin
               Debug(
{$ifdef JGO}
               sep+
{$endif}
               'Processing partitions', DebugMedium);
               if Buffer.Table[i].sys_ind <> 0 then
               begin
                  Debug(
{$ifdef JGO}
                  sep+
{$endif}
                  'Partition           ' + IntToStr(i) + ' /dev/hdx' + IntToStr(PartNo), DebugMedium);
                  Debug(' boot indicator      ' + IntToHex(Buffer.Table[i].boot_ind,2), DebugHigh);
                  Debug(' starting head       ' + IntToStr(Buffer.Table[i].head), DebugHigh);
                  Debug(' starting sector     ' + IntToStr(Buffer.Table[i].sector), DebugHigh);
                  Debug(' starting cylinder   ' + IntToStr(Buffer.Table[i].cyl), DebugHigh);
                  Debug(' partition type      ' + IntToHex(Buffer.Table[i].sys_ind,2), DebugMedium);
                  case Buffer.Table[i].sys_ind of
                     PARTITION_EXTENDED         : Debug('Extended... (dos)', DebugMedium);
                     PARTITION_EXTENDED_LINUX   : Debug('Extended... (linux)', DebugMedium);
                     PARTITION_EXTENDED_WIN98   : Debug('Extended... (win98)', DebugMedium);
                     PARTITION_FAT_16           : Debug('FAT 16', DebugMedium);
                     PARTITION_HUGE             : Debug('VFAT', DebugMedium);
                     PARTITION_IFS              : Debug('NTFS', DebugMedium);
                     PARTITION_LINUX            : Debug('Linux', DebugMedium);
                     PARTITION_LINUX_SWAP       : Debug('Linux Swap', DebugMedium);
{$ifdef JGO}
{****************************************************************************
Thu 4/27/2006 9:24 am. these extra types were immaterial -- at least regarding
my effort to see ext2 systems -- but what the heck....
****************************************************************************}
               PARTITION_B_WIN95_OSR2_FAT32     : Debug('Win98se FAT32',DebugMedium);
               PARTITION_C_WIN95_OSR2_FAT32_LBA : Debug('Win98se FAT32 LBA',DebugMedium);
               PARTITION_E_WIN95_FAT16_LBA      : Debug('Win98se FAT16 LBA',DebugMedium);
//                 PARTITION_WIN95_EXTENDED_LBA   : Debug('Extended LBA... (win98)',DebugMedium);
//nah he's got PARTITION_EXTENDED_WIN98
{$endif}
                  else
                     Debug('Unknown', DebugMedium);
                  end;
                  Debug('end head            ' + IntToStr(Buffer.Table[i].end_head), DebugHigh);
                  Debug('end sector          ' + IntToStr(Buffer.Table[i].end_sector), DebugHigh);
                  Debug('end cylinder        ' + IntToStr(Buffer.Table[i].end_cyl), DebugHigh);
                  Debug(' starting sector     ' + IntToStr(Buffer.Table[i].start_sect), DebugMedium);
                  Debug(' number of sectors   ' + IntToStr(Buffer.Table[i].nr_sects), DebugMedium);
                  Debug('', DebugMedium);

                  NewPart := nil;
                  if Disk.ReadSector(Buffer.Table[i].start_sect + 2, @superblock, sizeof(superblock) div 512) then
                  begin
                     if (superblock.s_magic = EXT2_SUPER_MAGIC)
{$ifdef JGO}
                     or
                     (mainform.options.AssumeExt2
                     and (buffer.table[i].sys_ind = PARTITION_LINUX)
                     and (superblock.s_magic = EXT2_PARTITION_MAGIC)
                     )
{$endif}
                     then
                     begin
                        Debug('EXT2 Found. magic = 0x' + IntToHex(superblock.s_magic, 4), DebugOff);

                        if (Buffer.Table[i].sys_ind = PartType) or (PartType = 0) then
                        begin
                           NewPart := TPartition.Create;
                           Partitions.add(NewPart);
                           NewPart.DriveNo   := DriveNo;// - $80;
                           NewPart.FileName  := '';

                           NewPart.Cylinders.QuadPart := Disk.GetGeometry.Cylinder + 1;
                           NewPart.TracksPerCylinder  := Disk.GetGeometry.Head + 1;
                           NewPart.SectorsPerTrack    := Disk.GetGeometry.Sector;
                           NewPart.BytesPerSector     := 512;
                           NewPart.MediaType          := Media_Type_FixedMedia;

                           NewPart.PartitionType            := Buffer.Table[i].sys_ind;
                           NewPart.BootIndicator            := (Buffer.Table[i].boot_ind = $80);
                           NewPart.RecognizedPartition      := True;
                           NewPart.RewritePartition         := False;
                           NewPart.PartNo                   := PartNo;
                           NewPart.StartingOffset.QuadPart  := (Buffer.Table[i].start_sect + Sector);// Offset from start of partition
   //                        NewPart.StartingOffset.QuadPart  := NewPart.StartingOffset.QuadPart * Geometry.BytesPerSector;
                           NewPart.PartitionLength.QuadPart := Buffer.Table[i].nr_sects;
   //                        NewPart.PartitionLength.QuadPart := NewPart.PartitionLength.QuadPart * Geometry.BytesPerSector;
                           NewPart.HiddenSectors            := 0;

                        end;
                     end;
                     if (Buffer.Table[i].sys_ind in EXTENDED_PARTITIONS) and (PartNo > 4) then
                     begin
                        Dec(PartNo); // We do not want to assign a number to extend partitions after the 1st (I don't know why?, it is what Linux does)
                     end;
                  end;

                  if NewPart = nil then
                  begin
                     if CheckForReiser(Disk, Buffer.Table[i].start_sect) then
                     begin
                        ReiserFSCount := ReiserFSCount + 1;
                     end;
                  end;

                  Inc(PartNo);
               end;
            end;
            for i := 1 to 4 do
            begin
               if Buffer.Table[i].sys_ind in EXTENDED_PARTITIONS then
               begin
                  Debug('Processing extended partition....', DebugMedium);
                  if Depth < 32 then
                  begin
                     if PartNo < 5 then
                     begin
                        PartNo := 5;
                     end;
                     if Depth = 1 then
                     begin
                        ExtendedStart := Sector;
                     end;
                     // There is a new partition table at offset start_sect...
                     if Depth >= 2 then
                     begin
                     if not ProcessSector(Disk, ExtendedStart + Buffer.Table[i].start_sect, Depth + 1) then
                        begin
                           Debug('Did not seem to be a valid extended partition', DebugMedium);
                        end;
                     end
                     else
                     begin
                        if not ProcessSector(Disk, Sector + Buffer.Table[i].start_sect, Depth + 1) then
                        begin
                           Debug('Did not seem to be a valid extended partition', DebugMedium);
                        end;
                     end;
                  end
                  else
                  begin
                     Debug('More than 32 partitions detected! This is most likely a bug!', DebugOff);
                  end;
               end;
            end;
         end
         else
         begin
            Result := False;
         end;
      end;
begin
   Disk := T95Disk.Create(UseEI13);
   try
      DriveNo := $80;

      while true do
      begin
         Debug(
{$ifdef JGO}
         sep+
{$endif}
         'Scanning disk ' + IntToHex(DriveNo, 2)
{$ifdef JGO}
         +sep
{$endif}
         , DebugMedium);

         if not Disk.SetDisk(DriveNo) then
         begin
               // no more physical drives found...
               break;
         end
         else // we have the handle, lets look at the partitions....
         begin
            // first see if the media is present...
               // Time to read the table
               PartNo := 1;
               ExtendedStart := 0;
               ProcessSector(Disk, 0, 0);
            Inc(DriveNo);
         end;
      end;

      ////////////////////////////////////////////
      ////////////////////////////////////////////
      ////////////////////////////////////////////
      ////////////////////////////////////////////

      if ScanFloppy then
      begin
         DriveNo := 0;

         while true do
         begin
            Debug(
{$ifdef JGO}
            sep+
{$endif}
            'Scanning ' + IntToHex(DriveNo, 2), DebugMedium);
            if not Disk.SetDisk(DriveNo) then
            begin
               break;
            end
            else // we have the handle, lets look at the partitions....
            try
               // Time to read the table
               PartNo := 1;
               ExtendedStart := 0;
               ProcessSector(Disk, 0, 0);
               Debug('PartNo = ' + IntToStr(PartNo), DebugMedium);
//               if PartNo = 1 then
               begin
                  // no Partitons found, should we add the whole disk?
                  AddFloppy(Disk);
               end;
            finally
               Inc(DriveNo);
            end;
         end;
      end;
   finally
      Disk.Free;
   end;
end;


