unit options;

{$I jgoops.i}

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, RegUtil, Dialogs, Spin;

type
  TOptions = class
  public
    ShowDotFiles  : Boolean;
    ShowBackups   : Boolean;
    DebugLevel    : Integer;
    AutoSave      : Boolean;
    DirsInList    : Boolean;

    ShowDebug   : Boolean;
    ShowStatus  : Boolean;
    ShowToolbar : Boolean;

    ViewStyle : TViewStyle;

    Prefix : String;

    WriteSupport  : Boolean;
    FloppyScan    : Boolean;

    NonStandard : Integer;

    UseEI13    : Boolean;
    UseNative  : Boolean;
{$ifdef JGO}
    AssumeExt2 : Boolean;
    ExportDir : String;
    zcount : integer;
    us_dates : Boolean;
{$endif}

    UMask      : String;

    PasswdFile : String;
    GroupFile  : String;

    ViewerProg : String;
    ViewText   : Boolean;

    SortColumn : Integer;
    SortDir    : Boolean;

    ColumnWidths : TList;


    constructor Create;
    destructor Destroy; override;
    function Execute : Boolean;

    procedure ReadOptions;
    procedure SaveOptions;

    function GetUMask : Integer;
  end;

  TOptionsDlg = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    DebugLevel: TRadioGroup;
    DebugWindow: TCheckBox;
    GroupBox1: TGroupBox;
    DotFiles: TCheckBox;
    Backups: TCheckBox;
    GroupBox2: TGroupBox;
    ToolbarCheckBox: TCheckBox;
    StatusCheckBox: TCheckBox;
    TabSheet3: TTabSheet;
    Label1: TLabel;
    PrefixEdit: TEdit;
    RWCheckBox: TCheckBox;
    NonStandardCheckBox: TCheckBox;
    NonStandardEdit: TEdit;
    Label2: TLabel;
    FloppyCheckBox: TCheckBox;
    Bevel1: TBevel;
    Label3: TLabel;
    UMaskEdit: TEdit;
    TabSheet4: TTabSheet;
    Label4: TLabel;
    PasswdEdit: TEdit;
    Label5: TLabel;
    GroupEdit: TEdit;
    PasswdButton: TButton;
    GroupButton: TButton;
    OpenDialog1: TOpenDialog;
    Label6: TLabel;
    ViewerEdit: TEdit;
    ViewerButton: TButton;
    ViewTextCheckBox: TCheckBox;
    AutoSaveCheckBox: TCheckBox;
    UseEI13CheckBox: TCheckBox;
    ListDirs: TCheckBox;
    UseNative: TCheckBox;
    CheckBox_AssumeExt2: TCheckBox;
    SpinEdit_zcount: TSpinEdit;
    Label7: TLabel;
    CheckBox_USdates: TCheckBox;
    procedure RWCheckBoxClick(Sender: TObject);
    procedure NonStandardCheckBoxClick(Sender: TObject);
    procedure PasswdButtonClick(Sender: TObject);
    procedure GroupButtonClick(Sender: TObject);
    procedure ViewerButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure UseNativeClick(Sender: TObject);
    procedure UseEI13CheckBoxClick(Sender: TObject);
    procedure FloppyCheckBoxClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CheckBox_AssumeExt2Click(Sender: TObject);
    procedure CheckBox_USdatesClick(Sender: TObject);
  private
    { Private declarations }
    CurrentOptions : TOptions;
  public
    { Public declarations }
    RequireRescan : Boolean;
  end;

var
  OptionsDlg: TOptionsDlg;

implementation

uses ex2explore;

{$R *.DFM}

/////////////////////////////
// TOptions
/////////////////////////////

constructor TOptions.Create;
begin
   ColumnWidths := Tlist.Create;
   ReadOptions;
end;

destructor TOptions.Destroy;
begin
   SaveOptions;
   ColumnWidths.Free;
end;

function TOptions.Execute : Boolean;
var
   Dlg : TOptionsDlg;
begin
   //
   Dlg := TOptionsDlg.Create(Application.MainForm);
   try
      Dlg.CurrentOptions := self;

      Dlg.DotFiles.Checked := ShowDotFiles;
      Dlg.Backups.Checked  := ShowBackups;
      Dlg.ListDirs.Checked := DirsInList;

      Dlg.DebugLevel.ItemIndex     := DebugLevel;
      Dlg.DebugWindow.Checked      := ShowDebug;
      Dlg.AutoSaveCheckBox.Checked := AutoSave;

      Dlg.ToolbarCheckBox.Checked := ShowToolbar;
      Dlg.StatusCheckBox.Checked  := ShowStatus;

      Dlg.PrefixEdit.Text := Prefix;

      Dlg.RWCheckBox.Checked := WriteSupport;

      Dlg.FloppyCheckBox.Checked := FloppyScan;

      if NonStandard > 0 then
      begin
         Dlg.NonStandardCheckBox.Checked := True;
         Dlg.NonStandardEdit.Text := IntToHex(NonStandard, 2);
         Dlg.NonStandardEdit.Enabled := True;
      end
      else
      begin
         Dlg.NonStandardCheckBox.Checked := False;
         Dlg.NonStandardEdit.Enabled := False;
      end;

      Dlg.UseEI13CheckBox.Checked := UseEI13;
      Dlg.UseNative.Checked := UseNative;
{$ifdef JGO}
      Dlg.CheckBox_AssumeExt2.checked := AssumeExt2;
      Dlg.SpinEdit_zcount.value := zcount;
      Dlg.CheckBox_USdates.checked := us_dates;
{$endif}

      Dlg.UMaskEdit.Text := UMask;

      Dlg.PasswdEdit.Text  := PasswdFile;
      Dlg.GroupEdit.Text   := GroupFile;
      Dlg.ViewerEdit.Text  := ViewerProg;
      Dlg.ViewTextCheckBox.Checked := ViewText;

      if Dlg.ShowModal = mrOK then
      begin
         ShowDotFiles   := Dlg.DotFiles.Checked;
         ShowBackups    := Dlg.Backups.Checked;
         DirsInList     := Dlg.ListDirs.Checked;

         DebugLevel     := Dlg.DebugLevel.ItemIndex;
         ShowDebug      := Dlg.DebugWindow.Checked;
         AutoSave       := Dlg.AutoSaveCheckBox.Checked;

         ShowToolbar := Dlg.ToolbarCheckBox.Checked;
         ShowStatus  := Dlg.StatusCheckBox.Checked;

         Prefix := Dlg.PrefixEdit.Text;

         WriteSupport := False; //Dlg.RWCheckBox.Checked;
         FloppyScan   := Dlg.FloppyCheckBox.Checked;

         if Dlg.NonStandardCheckBox.Checked then
         begin
            NonStandard := StrToInt('$' + Dlg.NonStandardEdit.Text);
         end
         else
         begin
            NonStandard := 0;
         end;

         UseEI13 := Dlg.UseEI13CheckBox.Checked;
         UseNative := Dlg.UseNative.Checked;
{$ifdef JGO}
         AssumeExt2 := Dlg.CheckBox_AssumeExt2.Checked;
         zcount := Dlg.SpinEdit_zcount.value;
         us_dates := Dlg.CheckBox_USdates.checked;
{$endif}

         UMask := Dlg.UMaskEdit.Text;

         PasswdFile  := Dlg.PasswdEdit.Text;
         GroupFile   := Dlg.GroupEdit.Text;
         ViewerProg  := Dlg.ViewerEdit.Text;
         ViewText    := Dlg.ViewTextCheckBox.Checked;

         Result := True;
      end
      else
      begin
         Result := False;
      end;
   finally
      Dlg.Free;
   end;
end;

procedure TOptions.ReadOptions;
var
   Reg : TSoftwareRegistry;
   i     : Integer;
   Width : Integer;
begin
   // Be a real prick and use the registry
   Reg := TSoftwareRegistry.Create('Newbigin', 'explore2fs');
   try
      ShowDotFiles   := Reg.GetBool('ShowDotFiles', True);
      ShowBackups    := Reg.GetBool('ShowBackups',  True);
      DirsInList     := Reg.GetBool('ListDirectories',  False);

      DebugLevel  := Reg.GetInteger('DebugLevel', DebugOff);
      AutoSave    := Reg.GetBool('AutoSaveDebug', True);

      ShowDebug    := Reg.GetBool('ShowDebug',   False);
      ShowStatus   := Reg.GetBool('ShowStatus',  True);
      ShowToolbar  := Reg.GetBool('ShowToolbar', True);

      ViewStyle := TViewStyle(Reg.GetInteger('ViewStyle', Integer(vsIcon)));

      Prefix := Reg.GetString('Prefix', 'hd');

      WriteSupport   := Reg.GetBool('DangerWriteSupport', False);
      FloppyScan     := Reg.GetBool('Floppy', False);

      NonStandard := Reg.GetInteger('NonStandard', 0);
      UseEI13     := Reg.GetBool('ExtendedInt13', True);
      UseNative   := Reg.GetBool('NativeIO', True);
{$ifdef JGO}
      AssumeExt2  := Reg.GetBool('AssumeExt2',true);
      ExportDir   := Reg.GetString('ExportDir','');
      zcount      := Reg.GetInteger('zcount',0);
      us_dates    := Reg.GetBool('us_dates',false);
{$endif}

      UMask := Reg.GetString('umask', '022');

      PasswdFile := Reg.GetString('PasswdFile', '');
      GroupFile  := Reg.GetString('GroupFile',  '');

      ViewerProg := Reg.GetString('Viewer',  'write');
      ViewText   := Reg.GetBool('ViewText',  false);

      SortColumn := Reg.GetInteger('SortColumn', 0);
      SortDir    := Reg.GetBool('SortDir',  false);

      // read the column header widths
      i := 0;
      while True do
      begin
         Width := Reg.GetInteger('Column' + IntToStr(i), -1);
         if Width <> -1 then
         begin
            ColumnWidths.Add(Pointer(Width));
            i := i + 1;
         end
         else break;
      end;

   finally
      Reg.Free;
   end;
end;

procedure TOptions.SaveOptions;
var
   Reg : TSoftwareRegistry;
   i   : Integer;
begin
   // Be a real prick and use the registry
   Reg := TSoftwareRegistry.Create('Newbigin', 'explore2fs');
   try
      Reg.SetBool('ShowDotFiles', ShowDotFiles);
      Reg.SetBool('ShowBackups',  ShowBackups);
      Reg.SetBool('ListDirectories', DirsInList);

      Reg.SetInteger('DebugLevel', DebugLevel);
      Reg.SetBool('AutoSaveDebug', AutoSave);

      Reg.SetBool('ShowDebug',   ShowDebug);
      Reg.SetBool('ShowStatus',  ShowStatus);
      Reg.SetBool('ShowToolbar', ShowToolbar);

      Reg.SetInteger('ViewStyle', Integer(ViewStyle));

      Reg.SetString('Prefix', Prefix);

      Reg.SetBool('WriteSupport', WriteSupport);
      Reg.SetBool('Floppy', FloppyScan);

      Reg.SetInteger('NonStandard', NonStandard);
      Reg.SetBool('ExtendedInt13', UseEI13);
      Reg.SetBool('NativeIO', UseNative);
{$ifdef JGO}
      Reg.SetBool('AssumeExt2',AssumeExt2);
      Reg.SetString('ExportDir',ExportDir);
      reg.SetInteger('zcount',zcount);
      Reg.SetBool('us_dates',us_dates);
{$endif}

      Reg.SetString('umask', UMask);

      Reg.SetString('PasswdFile', PasswdFile);
      Reg.SetString('GroupFile',  GroupFile);

      Reg.SetString('Viewer', ViewerProg);
      Reg.SetBool('ViewText', ViewText);

      Reg.SetInteger('SortColumn', SortColumn);
      Reg.SetBool('SortDir', SortDir);

      for i := 0 to ColumnWidths.Count - 1 do
      begin
         Reg.SetInteger('Column' + IntToStr(i), Integer(ColumnWidths[i]));
      end;
   finally
      Reg.Free;
   end;
end;

function TOptions.GetUMask : Integer;
var
   i     : Integer;
   Mask  : Integer;
begin
   // convert the UMask octal string into a decimal
//   UMask := '0' + UMask;
   Mask := 0;
   for i := 1 to Length(UMask) do
   begin
      if UMask[i] in ['0'..'7'] then
      begin
         Mask := (Mask * 8) + (Ord(UMask[i]) - Ord('0'));
      end
      else
      begin
         break;
      end;
   end;

   // now we have the mask
   // but we realy want to return the permissions to give the file
   Result := ($1B6 and (not mask)) and $1FF;
end;

procedure TOptionsDlg.RWCheckBoxClick(Sender: TObject);
begin
   if RWCheckBox.Focused and RWCheckBox.Checked then
   begin
      MessageDlg('WARNING'#10'Write support is experimental, use at your own risk!', mtInformation, [mbOK], 0);
      if MessageDlg('WARNING'#10'Are you sure you have done a backup of your system?', mtInformation, [mbYes, mbNo], 0) = mrNo then
      begin
         RWCheckBox.Checked := False;
      end;
   end;
   RequireRescan := True;
end;

procedure TOptionsDlg.NonStandardCheckBoxClick(Sender: TObject);
begin
   NonStandardEdit.Enabled := NonStandardCheckBox.Checked;
   RequireRescan := True;
end;

procedure TOptionsDlg.PasswdButtonClick(Sender: TObject);
begin
   OpenDialog1.FilterIndex := 2; // I hope
   OpenDialog1.FileName := PasswdEdit.Text;
   if OpenDialog1.Execute then
   begin
      PasswdEdit.Text := OpenDialog1.FileName;
   end;
end;

procedure TOptionsDlg.GroupButtonClick(Sender: TObject);
begin
   OpenDialog1.FilterIndex := 3;
   OpenDialog1.FileName := GroupEdit.Text;
   if OpenDialog1.Execute then
   begin
      GroupEdit.Text := OpenDialog1.FileName;
   end;
end;

procedure TOptionsDlg.ViewerButtonClick(Sender: TObject);
begin
   OpenDialog1.FilterIndex := 4;
   OpenDialog1.FileName := ViewerEdit.Text;
   if OpenDialog1.Execute then
   begin
      ViewerEdit.Text := OpenDialog1.FileName;
   end;
end;

procedure TOptionsDlg.FormCreate(Sender: TObject);
begin
   if not MainForm.OSis95 then
   begin
      UseEI13CheckBox.Visible := False;
{$ifdef JGO_ah_let_it_be}
      CheckBox_AssumeExt2.visible := false;
//I couldn't figure-out how to fix the XP version -- and don't have an
//XP/Linux system to test.
{$endif}
   end
   else
   begin
      UseNative.Visible := False;
   end;
end;

procedure TOptionsDlg.OKBtnClick(Sender: TObject);
begin
   if RequireRescan then
   begin
      MessageDlg('You have changed the way in which Explore2fs reads the disks attached to'#10 +
                 'your system.  These changes will not take effect until you restart this'#10 +
                 'program or select ''Rescan Partitions'' from the file menu', mtInformation, [mbOK], 0);
   end;
end;

procedure TOptionsDlg.UseNativeClick(Sender: TObject);
begin
   RequireRescan := True;
end;

procedure TOptionsDlg.UseEI13CheckBoxClick(Sender: TObject);
begin
   RequireRescan := True;
end;

procedure TOptionsDlg.FloppyCheckBoxClick(Sender: TObject);
begin
   RequireRescan := True;
end;

procedure TOptionsDlg.FormShow(Sender: TObject);
begin
   RequireRescan := False;
end;

{$ifdef JGO}
procedure TOptionsDlg.CheckBox_AssumeExt2Click(Sender: TObject);
const
here : boolean = false;
begin
  if here or (not CheckBox_AssumeExt2.focused) then
  exit;

  here := true;
  if CheckBox_AssumeExt2.checked then begin
    if MessageDlg(
    'Linux and perhaps other partitions may be assumed to be ext2; if '+
    'the partition isn''t, '+
    'everything explodes.... OK?',
    mtInformation, [mbYes, mbNo], 0) = mrNo then
    begin
       CheckBox_AssumeExt2.checked := False;
    end else
  end;
  requirerescan := true;
  here := false;
end;
{$else}
procedure TOptionsDlg.CheckBox_AssumeExt2Click(Sender: TObject);
begin
end;
{$endif}

procedure TOptionsDlg.CheckBox_USdatesClick(Sender: TObject);
begin
{$ifdef JGO}
  mainform.Options.us_dates := CheckBox_USdates.checked;
{$endif}
end;

end.
