{copyright (c) J. G. Owen 2003}
{entire module.}

unit help;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls;

type
  Thelpf = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Panel_Bottom: TPanel;
    Edit1: TEdit;
    Button_Search: TButton;
    RichEdit_TeciFake: TRichEdit;
    RichEdit_teci: TRichEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button_SearchClick(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PageControl1Resize(Sender: TObject);
  private
    { Private declarations }
    search_position:integer;
    procedure xinit;
    procedure search;
  public
    { Public declarations }
    showing : boolean;
  end;

var
  helpf: Thelpf;

implementation

{$R *.DFM}

uses sbrs;

procedure loadahelp(m:TRichEdit; filename:string);
begin
  try
    m.text := format('couldn''t load %s',[filename]);
    m.lines.loadfromfile(filename);
  except
    on exception
    do;
  end;
end;


procedure Thelpf.FormCreate(Sender: TObject);
begin
  autoscroll := true;
//  PageControl1.pages[1].free; //.enabled := false;
//  PageControl1.pages[1] := nil;

//I'm leaving it so I can use it someday?

{****************************************************************************
Thu 3/02/2006 12:05 pm. So the way to disable the tab is

1. Find TabSheet2 in the object inspector. As far as I know, that's the only
way to select it.

2. Don't bother with visible, enable. They're there, but don't do anything.
Set *TabVisible* to false....

And I did it in the object inspector of course, not here....

****************************************************************************}


end;

procedure Thelpf.FormShow(Sender: TObject);
begin
  xinit;

  loadahelp(richedit_tecifake,fpgmdirize('e2fshelp.txt'));

  showing := true;
  edit1.setfocus;
end;

procedure Thelpf.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  RichEdit_TeciFake.clear;
  RichEdit_Teci.clear;
  showing := false;
end;

procedure Thelpf.xinit;
const
done : boolean = false;
begin
  if done then
  exit;

  PageControl1.activepageindex := 0;
  search_position := 0;

end;


procedure Thelpf.Button_SearchClick(Sender: TObject);
begin
  search;
end;

procedure Thelpf.PageControl1Change(Sender: TObject);
begin
  search_position := 0;
end;

procedure Thelpf.search;
var
help:TRichEdit;
what : integer;
begin
  if PageControl1.activepageindex=0 then
  help := richedit_tecifake
  else
  help := richedit_teci;

//  help.selstart := 0;
//  help.sellength := 0;
//  help.seltext := '';
//  help.SelectAll;
//  infof('ho',[0]);

//  help.setfocus;

  what := help.FindText(edit1.text,search_position,high(integer),[]);
  if (what<0) then
  search_position := 0
  else begin
    try
      help.selstart := what + 200;
      help.sellength := 1;
      SendMessage(help.handle,EM_SCROLLCARET,0,0);

    except
      on exception
      do ;
    end;

    help.selstart := what;
    help.sellength := length(edit1.text);
    SendMessage(help.handle,EM_SCROLLCARET,0,0);
{****************************************************************************
This is the EZ handy so-intuitive way we get Delphi to show the found line.
Why didn't I think of that? Thank goodness for the innernet, and
http://www.delphifaq.com/faq/delphi/vcl/f282.shtml
****************************************************************************}

    search_position := what+1;
  end;

  help.setfocus;  //or I can't see the selection, see?

end;

procedure Thelpf.Edit1Change(Sender: TObject);
begin
  button_search.enabled := length(Edit1.text)>0;
end;

procedure Thelpf.Edit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case key of
    vk_return, ord('G')-CTL: begin
      key := 0;
      search;
    end;
  end;

end;

procedure Thelpf.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
//doesn't work of course.
  case key of
    ord('G')-CTL: begin
      key := 0;
      search;
    end;
  end;

end;

procedure Thelpf.PageControl1Resize(Sender: TObject);
begin
  if not os_isxp then
  exit;

  PageControl1.visible := false;
  PageControl1.visible := true;
//else it strews debris in the edit form.
end;

end.
