unit Partition;

{$I jgoops.i}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Native;

type

{$A-,Z+}

 TPartEntry = record
        boot_ind    : Byte;             // 0x80 - active
        head        : Byte;             // starting head
        sector      : Byte;             // starting sector
        cyl         : Byte;             // starting cylinder
        sys_ind     : Byte;             // What partition type
        end_head    : Byte;             // end head
        end_sector  : Byte;        // end sector
        end_cyl     : Byte;             // end cylinder
        start_sect  : UINT;        // starting sector counting from 0
        nr_sects    : UINT;     // nr of sectors in partition
  end;

  TDiskTable = record
   Data  : array[1..446] of Char;
   Table : array[1..4] of TPartEntry;

   Signature : WORD;
  end;

{$A+,Z+}

 TPartition = class
// private
  public
   DriveNo              : Integer;
   PartNo               : Integer;
   FileName             : String;
   DeviceName           : String;

   Cylinders         : _LARGE_INTEGER;
   MediaType         : Integer;
   TracksPerCylinder : DWORD;
   SectorsPerTrack   : DWORD;
   BytesPerSector    : DWORD;

   PartitionType        : Integer;
   BootIndicator        : BOOLEAN;
   RecognizedPartition  : BOOLEAN;
   RewritePartition     : BOOLEAN;
   StartingOffset       : _LARGE_INTEGER;//TLargeInteger;
   PartitionLength      : _LARGE_INTEGER;//TLargeInteger;
   HiddenSectors        : DWORD;

{$ifdef JGO}
   zcount : integer;
{$endif}

 public
   procedure Dump;
 end;

 TPartitionList = class
 public
   ScanFloppy : Boolean;

   ReiserFSCount : Integer;

   constructor Create;
   destructor Destroy; override;

{****************************************************************************
JGO. NT_scan and Win95_scan use facilities in respective operating systems.
LL_Scan isn't used anymore and I don't know what it is.
****************************************************************************}
   procedure NT_Scan;
   procedure LL_Scan(PartType : Integer);
   procedure Win95_Scan(PartType : Integer; UseEI13 : Boolean);
   procedure Dump;
   function Count : Integer;
   function GetPartition(i : Integer) : TPartition;

 private
   Partitions : TList;

   function MediaPresent(h : THandle) : Boolean;
 end;


 function YesNo(b : Boolean) : String;


implementation

uses WinIOCTL, ex2explore, DiskIO, ex2, lvm2;

{$ifdef JGO}
const sep = '--------------------------'+#13+#10;
{$endif}

function YesNo(b : Boolean) : String;
begin
   if b then
   begin
      Result := 'Yes';
   end
   else
   begin
      Result := 'No';
   end;
end;

function LockVolume(h : THandle) : Boolean;
var
   ReturnedByteCount : DWORD;
begin
   Result := DeviceIoControl(h,
                CtlCode(FILE_DEVICE_FILE_SYSTEM, 6, METHOD_BUFFERED, FILE_ANY_ACCESS),
                nil,
                0,
                nil,
                0,
                ReturnedByteCount,
                nil);
end;

function UnLockVolume(h : THandle) : Boolean;
var
   ReturnedByteCount : DWORD;
begin
   Result := DeviceIoControl(h,
                CtlCode(FILE_DEVICE_FILE_SYSTEM, 7, METHOD_BUFFERED, FILE_ANY_ACCESS),
                nil,
                0,
                nil,
                0,
                ReturnedByteCount,
                nil);
end;

constructor TPartitionList.Create;
begin
   ScanFloppy := False;
   Partitions := TList.Create;
   ReiserFSCount := 0;
end;

destructor TPartitionList.Destroy;
var
   i : Integer;
begin
   for i := 0 to Partitions.Count - 1 do
   begin
      TPartition(Partitions[i]).Free;
   end;
   Partitions.Free;
end;

function TPartitionList.Count : Integer;
begin
   Result := Partitions.Count;
end;

function TPartitionList.GetPartition(i : Integer) : TPartition;
begin
   Result := TPartition(Partitions[i]);
end;

{****************************************************************************
****************************************************************************}

{$I part_low.pas}
{****************************************************************************
****************************************************************************}
{$I part_nt.pas}
{****************************************************************************
****************************************************************************}

function TPartitionList.MediaPresent(h : THandle) : Boolean;
var
   Length : DWord;
begin
   Debug('Looking for media...', DebugHigh);
   Result := DeviceIOControl(h, CtlCode(IOCTL_STORAGE_BASE, $200, METHOD_BUFFERED, FILE_READ_ACCESS),
       nil, 0, nil, 0, Length, nil)
//CTL_CODE(IOCTL_STORAGE_BASE, 0x0200, METHOD_BUFFERED, FILE_READ_ACCESS)
end;

procedure TPartitionList.Dump;
var
   i : Integer;
begin
   for i := 0 to Partitions.Count - 1 do
   begin
      TPartition(Partitions[i]).Dump;
   end;
end;

procedure TPartition.Dump;
begin
   Debug('Partition number ' + IntToStr(PartNo) + ' on drive ' + IntToStr(DriveNo), DebugMedium);
   Debug(FileName, DebugMedium);

   Debug('Media type ' + IntToStr(MediaType), DebugMedium);
   Debug('Cylinders        : ' + IntToStr(Cylinders.QuadPart), DebugMedium);
   Debug('Tracks / Cylinder : ' + IntToStr(TracksPerCylinder), DebugMedium);
   Debug('Sectors / Track   : ' + IntToStr(SectorsPerTrack), DebugMedium);
   Debug('Bytes / Sector    : ' + IntToStr(BytesPerSector), DebugMedium);

   Debug('Partition:', DebugMedium);

   Debug('Type       : ' + IntToHex(PartitionType, 4), DebugMedium);
   Debug('Bootable   : ' + YesNo(BootIndicator), DebugMedium);
   Debug('Recognised : ' + YesNo(RecognizedPartition), DebugMedium);
   Debug('Rewrite    : ' + YesNo(RewritePartition), DebugMedium);

   Debug('Starting Offset : ' + IntToStr(StartingOffset.QuadPart), DebugMedium);

   Debug('Partition Length : ' + IntToStr(PartitionLength.QuadPart), DebugMedium);
   Debug('Hidden sectors : ' + IntToStr(HiddenSectors), DebugMedium);
   Debug('', DebugMedium);
   Debug('', DebugMedium);
end;

{****************************************************************************
****************************************************************************}
{$I part_95.pas}
{****************************************************************************
****************************************************************************}


end.





